/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.block.AutoMechanicTableBlock;
import io.github.foundationgames.automobility.block.AutomobileAssemblerBlock;
import io.github.foundationgames.automobility.block.AutomobilePressurePlateBlock;
import io.github.foundationgames.automobility.block.AutopilotSignBlock;
import io.github.foundationgames.automobility.block.DashPanelBlock;
import io.github.foundationgames.automobility.block.LaunchGelBlock;
import io.github.foundationgames.automobility.block.OffRoadBlock;
import io.github.foundationgames.automobility.block.SlopeBlock;
import io.github.foundationgames.automobility.block.SlopeWithDashPanelBlock;
import io.github.foundationgames.automobility.block.SteepSlopeBlock;
import io.github.foundationgames.automobility.block.SteepSlopeWithDashPanelBlock;
import io.github.foundationgames.automobility.block.entity.AutomobileAssemblerBlockEntity;
import io.github.foundationgames.automobility.block.entity.AutopilotSignBlockEntity;
import io.github.foundationgames.automobility.item.AutopilotSignBlockItem;
import io.github.foundationgames.automobility.item.CreativeTabQueue;
import io.github.foundationgames.automobility.item.DashPanelItem;
import io.github.foundationgames.automobility.item.SlopeBlockItem;
import io.github.foundationgames.automobility.item.SteepSlopeBlockItem;
import io.github.foundationgames.automobility.item.TooltipBlockItem;
import io.github.foundationgames.automobility.platform.Platform;
import io.github.foundationgames.automobility.util.AUtils;
import io.github.foundationgames.automobility.util.Eventual;
import io.github.foundationgames.automobility.util.RegistryQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;

public final class AutomobilityBlocks
extends Enum<AutomobilityBlocks> {
    public static final Eventual<Block> AUTO_MECHANIC_TABLE;
    public static final Eventual<Block> AUTOMOBILE_ASSEMBLER;
    public static final Eventual<Block> AUTOPILOT_SIGN;
    public static final Eventual<Block> AUTOMOBILE_PRESSURE_PLATE;
    public static final Eventual<Block> SLOPE;
    public static final Eventual<Block> STEEP_SLOPE;
    public static final Eventual<Block> SLOPE_WITH_DASH_PANEL;
    public static final Eventual<Block> STEEP_SLOPE_WITH_DASH_PANEL;
    public static final Eventual<Block> DASH_PANEL;
    public static final Eventual<Block> GRASS_OFF_ROAD;
    public static final Eventual<Block> DIRT_OFF_ROAD;
    public static final Eventual<Block> SAND_OFF_ROAD;
    public static final Eventual<Block> SNOW_OFF_ROAD;
    public static final Eventual<Block> LAUNCH_GEL;
    public static final Eventual<Block> ALLOW;
    public static final Eventual<BlockEntityType<AutomobileAssemblerBlockEntity>> AUTOMOBILE_ASSEMBLER_ENTITY;
    public static final Eventual<BlockEntityType<AutopilotSignBlockEntity>> AUTOPILOT_SIGN_ENTITY;
    private static final /* synthetic */ AutomobilityBlocks[] $VALUES;

    public static AutomobilityBlocks[] values() {
        return (AutomobilityBlocks[])$VALUES.clone();
    }

    public static AutomobilityBlocks valueOf(String name) {
        return Enum.valueOf(AutomobilityBlocks.class, name);
    }

    public static void init() {
    }

    public static Eventual<Block> register(String name, Supplier<Block> block) {
        return RegistryQueue.register(BuiltInRegistries.BLOCK, Automobility.rl(name), block);
    }

    public static Eventual<Block> register(String name, Supplier<Block> block, CreativeTabQueue group) {
        return AutomobilityBlocks.register(name, block, b -> new BlockItem(b, new Item.Properties()), group);
    }

    public static Eventual<Block> register(String name, Supplier<Block> block, Function<Block, BlockItem> item, CreativeTabQueue tab) {
        Eventual<Block> blockPromise = AutomobilityBlocks.register(name, block);
        Eventual<BlockItem> itemPromise = RegistryQueue.register(BuiltInRegistries.ITEM, Automobility.rl(name), () -> (BlockItem)item.apply((Block)blockPromise.require()));
        if (tab != null) {
            tab.queue(itemPromise);
        }
        return blockPromise;
    }

    public static Eventual<Block> register(String name, Supplier<Block> block, Function<Block, BlockItem> item) {
        return AutomobilityBlocks.register(name, block, item, null);
    }

    private static /* synthetic */ AutomobilityBlocks[] $values() {
        return new AutomobilityBlocks[0];
    }

    static {
        $VALUES = AutomobilityBlocks.$values();
        AUTO_MECHANIC_TABLE = AutomobilityBlocks.register("auto_mechanic_table", () -> new AutoMechanicTableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK)), Automobility.TAB);
        AUTOMOBILE_ASSEMBLER = AutomobilityBlocks.register("automobile_assembler", () -> new AutomobileAssemblerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ANVIL)), Automobility.TAB);
        AUTOPILOT_SIGN = AutomobilityBlocks.register("autopilot_sign", () -> new AutopilotSignBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_TRAPDOOR).lightLevel(s -> 1).emissiveRendering((s, l, p) -> true).noCollission()), b -> new AutopilotSignBlockItem((Block)b, new Item.Properties()), Automobility.TAB);
        AUTOMOBILE_PRESSURE_PLATE = AutomobilityBlocks.register("automobile_pressure_plate", () -> new AutomobilePressurePlateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE)), Automobility.TAB);
        SLOPE = AutomobilityBlocks.register("slope", () -> new SlopeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)), b -> new SlopeBlockItem((Block)b, new Item.Properties()), Automobility.TAB);
        STEEP_SLOPE = AutomobilityBlocks.register("steep_slope", () -> new SteepSlopeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)), b -> new SteepSlopeBlockItem((Block)b, new Item.Properties()), Automobility.TAB);
        SLOPE_WITH_DASH_PANEL = AutomobilityBlocks.register("slope_with_dash_panel", () -> new SlopeWithDashPanelBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(s -> (Boolean)s.getValue((Property)DashPanelBlock.POWERED) != false ? 0 : 1).emissiveRendering((s, l, p) -> (Boolean)s.getValue((Property)DashPanelBlock.POWERED) == false)));
        STEEP_SLOPE_WITH_DASH_PANEL = AutomobilityBlocks.register("steep_slope_with_dash_panel", () -> new SteepSlopeWithDashPanelBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(s -> (Boolean)s.getValue((Property)DashPanelBlock.POWERED) != false ? 0 : 1).emissiveRendering((s, l, p) -> (Boolean)s.getValue((Property)DashPanelBlock.POWERED) == false)));
        DASH_PANEL = AutomobilityBlocks.register("dash_panel", () -> new DashPanelBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(s -> (Boolean)s.getValue((Property)DashPanelBlock.POWERED) != false ? 0 : 1).emissiveRendering((s, l, p) -> (Boolean)s.getValue((Property)DashPanelBlock.POWERED) == false).noCollission()), b -> new DashPanelItem((Block)b, new Item.Properties()), Automobility.TAB);
        GRASS_OFF_ROAD = AutomobilityBlocks.register("grass_off_road", () -> new OffRoadBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK).noCollission(), AUtils.colorFromInt(4221208)), Automobility.TAB);
        DIRT_OFF_ROAD = AutomobilityBlocks.register("dirt_off_road", () -> new OffRoadBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).noCollission(), AUtils.colorFromInt(5849639)), Automobility.TAB);
        SAND_OFF_ROAD = AutomobilityBlocks.register("sand_off_road", () -> new OffRoadBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).noCollission(), AUtils.colorFromInt(12759429)), Automobility.TAB);
        SNOW_OFF_ROAD = AutomobilityBlocks.register("snow_off_road", () -> new OffRoadBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SNOW).noCollission(), AUtils.colorFromInt(13690861)), Automobility.TAB);
        LAUNCH_GEL = AutomobilityBlocks.register("launch_gel", () -> new LaunchGelBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CLAY).strength(0.1f).sound(SoundType.HONEY_BLOCK).noCollission()), Automobility.TAB);
        ALLOW = AutomobilityBlocks.register("allow", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK).sound(SoundType.METAL)), (Block b) -> new TooltipBlockItem((Block)b, (Component)Component.translatable((String)"tooltip.block.automobility.allow").withStyle(ChatFormatting.AQUA), new Item.Properties()));
        AUTOMOBILE_ASSEMBLER_ENTITY = RegistryQueue.register(BuiltInRegistries.BLOCK_ENTITY_TYPE, Automobility.rl("automobile_assembler"), () -> Platform.get().blockEntity(AutomobileAssemblerBlockEntity::new, AUTOMOBILE_ASSEMBLER.require()));
        AUTOPILOT_SIGN_ENTITY = RegistryQueue.register(BuiltInRegistries.BLOCK_ENTITY_TYPE, Automobility.rl("autopilot_sign"), () -> Platform.get().blockEntity(AutopilotSignBlockEntity::new, AUTOPILOT_SIGN.require()));
    }
}

